﻿Class MainWindow 

    ''' <summary>
    ''' Zlicza znaki w bloku tekstu.
    ''' </summary>
    ''' <param name="text">Ciąg znaków zawierający zliczane
    ''' znaki.</param>
    ''' <returns>Liczba znaków w ciągu.</returns>
    ''' <remarks></remarks>    
    Private Function CountCharacters(ByVal text As String) As Integer
        Return text.Length
    End Function

    Private Sub txtWords_TextChanged(ByVal sender As Object, _
        ByVal e As System.Windows.Controls.TextChangedEventArgs) _
        Handles txtWords.TextChanged

        'Tekst zmienił się, należy więc wyświetlić wynik.
        UpdateDisplay()

    End Sub

    ''' <summary>
    ''' Zlicza słowa w bloku tekstu.
    ''' </summary>
    ''' <param name="text">Ciąg znaków zawierający zliczane słowa.</param>
    ''' <returns>Liczba słów w ciągu znaków.</returns>
    ''' <remarks></remarks>
    Private Function CountWords(ByVal text As String) As Integer
        'Czy pole tekstowe nie jest puste?
        If text.Trim.Length = 0 Then Return 0

        'Rozbijanie tekstu na słowa.
        Dim strWords() As String = text.Split(" "c)

        'Zwracanie liczby słów.
        Return strWords.Length
    End Function

    Private Sub UpdateDisplay()
        'Jeśli nie zakończono inicjowania okna, należy wyjść
        'z procedury, ponieważ przycisk radCountWords
        'jeszcze nie istnieje.
        If Not Me.IsInitialized Then Exit Sub

        'Czy program ma zliczać słowa?
        If radCountWords.IsChecked Then
            'Aktualizacja wyników.
            lblResults.Content = CountWords(txtWords.Text) & " słów"
        Else
            'Aktualizacja wyników.
            lblResults.Content = CountCharacters(txtWords.Text) & " znaków"
        End If
    End Sub

    Private Sub radCountWords_Checked(ByVal sender As Object, _
        ByVal e As System.Windows.RoutedEventArgs) _
        Handles radCountWords.Checked

        'Tekst zmienił się, należy więc wyświetlić wynik.
        UpdateDisplay()
    End Sub

    Private Sub radCountChars_Checked(ByVal sender As Object, _
        ByVal e As System.Windows.RoutedEventArgs) _
        Handles radCountChars.Checked

        'Tekst zmienił się, należy więc wyświetlić wynik.
        UpdateDisplay()
    End Sub

End Class
